//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.data.Core 1.0
import wesual.Controls 1.0

PropertyEditor {
    id : editor

    property alias datePicker   : datePicker
    property alias dateString   : datePicker.text
    property alias selectedDate : datePicker.selectedDate
    property alias popup        : datePicker.popup
    property alias minimumDate  : datePicker.minimumDate
    property alias maximumDate  : datePicker.maximumDate

    implicitHeight : 26
    implicitWidth  : 110

    function setTime(time) {
        if (!document)
            return;

        var currentDate = document[editor.property];

        currentDate.setHours(time.getHours());
        currentDate.setMinutes(time.getMinutes());
        currentDate.setSeconds(time.getSeconds());

        document.beginRecordChanges();
        document[editor.property] = currentDate;
        document.endRecordChanges();
    }

    function commit() {
        if (!document)
            return;

        var newDate = datePicker.selectedDate;
        var oldDate = document[editor.property];

        oldDate.setFullYear(newDate.getFullYear());
        oldDate.setMonth(newDate.getMonth());
        oldDate.setDate(newDate.getDate());

        document.beginRecordChanges();
        document[editor.property] = oldDate;
        document.endRecordChanges();
    }

    DatePicker {
        id : datePicker

        anchors.fill : parent

        enabled : editor.document !== null && editor.enabled
        text : editor.document ? editor.document[editor.property] :
                                 selectedDate;

        onDateChosen : editor.commit()
    }
}
